Include([[Data/levels/include/level_utils.lua]])

-- lerp(a, b, k)
-- Returns a linear interpolation between a and b, based on the
-- coefficient k when it is in [0,1]. If k is outside this range,
-- the function returns extrapolated values along the same line.
function math.lerp(a, b, k)
    return a * (1-k) + b * k
end

function math.round(a)
    return math.floor(a + 0.5)    
end


function string:split(p_sep)
    local result = {}
    for token in string.gmatch(self, "[^,]+") do
       table.insert(result, token)
    end
    
    return result
end

local lastCaptureAdjustment = -1
if GameWorld:GetParamInt("Custom:StartMutations") > 0 then lastCaptureAdjustment = 0 end
local maxCaptures = GameWorld:GetParamInt("Custom:HiveCount") - 1
local captureMutations = GameWorld:GetParamInt("Custom:MutationCount") - GameWorld:GetParamInt("Custom:StartMutations")
local capturesPerMuta = math.floor(math.max((maxCaptures+lastCaptureAdjustment) / (captureMutations+lastCaptureAdjustment), (maxCaptures) / (captureMutations)))
local coveredCaptures = math.max(0, capturesPerMuta * (captureMutations+lastCaptureAdjustment)) - lastCaptureAdjustment
local queuePaddingCt = math.ceil((maxCaptures - coveredCaptures) * 0.3)
local queuePadding = {}

for i = 1, queuePaddingCt do
    table.insert(queuePadding, [[ZU_NONE]])
end

Level =
{
	MapSkinFilename = LevelUtils.PickRandomChoice(LevelUtils.GetAllSkinFilenames()),
	MapGenScript = function ()
	
		--Map Geometry
		MapGeometry:Randomize(GameWorld:GetParamFloat("Custom:MapSize"), GameWorld:GetParamFloat("Custom:MapFeatures"))
		MapEntities:SetParameters(LevelUtils.MapGenDefaults)
		MapEntities:GenerateLocations()
	
		local clusterK = GameWorld:GetParamFloat("Custom:HiveClustering")
		local hiveCount = GameWorld:GetParamInt("Custom:HiveCount")
		local easyPoints = math.round(math.min(math.lerp(6,0,math.pow(clusterK, 0.3)), hiveCount))
        
        local hiveCountLeft = hiveCount - easyPoints
        local hiveDifficultyCount = {0, 0, 0, 0, 0, 0}
        
        local highestLevel = (math.lerp(1,6,clusterK))
        local lowestLevel = (math.lerp(1,3,clusterK))
        local superClusterLevel = math.round(math.lerp(highestLevel,lowestLevel,math.pow(clusterK,2.0)))
        
        local reductionSteps = math.floor((highestLevel - lowestLevel)/2) + 1
        local reductionCtrMax = math.floor(hiveCountLeft / reductionSteps)
        local reductionCtr = reductionCtrMax
        
        while hiveCountLeft > 0 do
            for i=math.round(highestLevel), math.round(lowestLevel), -1 do
                if hiveCountLeft <= 0 then
                    break
                end
                
                hiveDifficultyCount[i] = hiveDifficultyCount[i] + 1
                reductionCtr = reductionCtr - 1
                hiveCountLeft = hiveCountLeft - 1
            end
            
            
            if reductionCtr <= 0 then
                lowestLevel = math.max(lowestLevel + 1, highestLevel)
                highestLevel = math.max(highestLevel - 1, lowestLevel)
                
                reductionCtr = reductionCtrMax
            end           
            
        end
 		
		for difficulty, numHivesOfThisDifficulty in ipairs(hiveDifficultyCount) do
---[[
			if difficulty == 1 then
			    Log(easyPoints+numHivesOfThisDifficulty .. " x PlaceCapPoint(" ..  difficulty-1 .. ")")
            else
			    Log(numHivesOfThisDifficulty .. " x PlaceCapPoint(" ..  difficulty-1 .. ")")
            end
---]]
            for i=1, numHivesOfThisDifficulty do
			    local minHives = -1
			    if difficulty > superClusterLevel then minHives = 1 end
				MapEntities:PlaceCapPoint(false, minHives, difficulty-1, true, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
			end
		end		
		
		for i=1, easyPoints do
		    MapEntities:PlaceCapPoint(false, -1, 0, false, LevelUtils.MapGenDefaults.CapPtExclusionRadius, "");
        end
		
		local homeBase = MapEntities:PlaceCapPoint(true, -1, 0, false, 90.0, "");
		GameWorld:AddMarines(homeBase:GetPos(), GameWorld:GetStartingTeamSize())
		GameWorld:ResetCamera(homeBase:GetPos())
		
		--Alien support structs
		local structParamTranslate = {}
		local structTypeList = {}
		
		structParamTranslate["Custom:MortarOn"]     = EntityArranger_EBType.BT_MORTAR
		structParamTranslate["Custom:TurretOn"]     = EntityArranger_EBType.BT_TURRET
		structParamTranslate["Custom:ShieldOn"]     = EntityArranger_EBType.BT_MEDICENT
		structParamTranslate["Custom:ProtohiveOn"]  = EntityArranger_EBType.BT_NECRONODE
		structParamTranslate["Custom:BulwarkOn"]    = EntityArranger_EBType.BT_HARDPOINT
		structParamTranslate["Custom:GuardiansOn"]  = EntityArranger_EBType.BT_HARDPOINT_GUARDS
		structParamTranslate["Custom:SiegeOn"]      = EntityArranger_EBType.BT_SIEGE
		structParamTranslate["Custom:MimicOn"]      = EntityArranger_EBType.BT_HARDPOINT_MIMICS
	
	    for key, value in pairs(structParamTranslate) do
	        if GameWorld:GetParamBool(key) then
	            table.insert(structTypeList, value)
            end
        end
		
		MapEntities:PlaceEnemyStuctures( GameWorld:GetParamFloat("Custom:ExtraDefense"),
                                         structTypeList);
		
		--Place crates
		for i=1, GameWorld:GetParamInt("Custom:CratesBP") do
			MapEntities:PlaceBPCrate(20.0, 60.0, 15.0);
		end
		
		for i=1, GameWorld:GetParamInt("Custom:CratesAP") do
			MapEntities:PlaceAPCrate(14.0, 20.0, 6.0);
		end		
	end,
	
	Parameters =
	{
		MarineCount 		= GameWorld:GetParamInt("Custom:TeamSize"),
		MaxHiveLevel 		= GameWorld:GetParamInt("Custom:HiveLevel"),
		MaxSpawnRate 		= GameWorld:GetParamInt("Custom:SpawnRate"),
		StartBPMultiplier 	= 1.0,
		BPGainMultiplier    = 1.0,
		
		StartBuildPoints    = GameWorld:GetParamInt("Custom:StartBP"),
		PointGainPerCapture = GameWorld:GetParamInt("Custom:RewardBP"),
		
		DefaultHiveTowerCount 	= GameWorld:GetParamInt("Custom:TowerCount"),
		HiveLifecycleK      	= GameWorld:GetParamFloat("Custom:HiveRespawn"),
	},
	Rules = 
	{
		AutoCapture 	= false,		--Destroying hives automatically counts as a capture
		NoPushback		= false,		--Can the player's points be captured?
		NoTowerRespawn  = false,        --Can the hive towers respawn?
		WeakenHiveOnCap = false,        --Do captures halve defensive strength?
		DisableLockdown = false,        --Turn off emergency help is player is behind
		SmartMutations	= GameWorld:GetParamBool("Custom:MaliciousMutations"),
	},
	Mutations =
	{
		CapturesPerMutation = capturesPerMuta,
		MaxMutations = GameWorld:GetParamInt("Custom:MutationCount"),
		Default = [[disabled]],
		Active = {},
		Queue =	queuePadding,
		Disabled = {},
		Inactive = string.split(GameWorld:GetParam("Custom:PossibleMutations"), ","),
		Randomize = true
	},
	MarineUpgrades = 
	{
		RandomResearchLockCount = GameWorld:GetParamInt("Custom:LockTech"),
		
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	OnDebugCall = function (mousePos)
		GameWorld:ApplyNextMutation(false)
	end
}


------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		
		CaptureAllObjective:Enable()
		
		for i = 1, GameWorld:GetParamInt("Custom:StartMutations") do
		    ScriptMgr:DoDelayedCall(2000 + (i-1)*300, function () GameWorld:ApplyNextMutation(true); end) --Random Mutation
		end
		
		self:Disable()
	end)
LevelInit:Enable()


------------------------------------------------------------------------------- Tracked objective for capturing everything
CaptureAllObjective = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("Objectives", true)
		GameWorld:AddObjective("winObj", "Capture all the enemy points")
			
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[complete]])
	
		self:Disable()
	end)
	
------------------------------------------------------------------------------- Victory Condition - Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ClearText()
		GameWorld:GameOver(true)
		
		self:Disable()
	end) 
CaptureAllGoal:Enable()

------------------------------------------------------------------------------- Lost all points
LossCondition = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_ALL_POINTS_LOST]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[failed]])
	
		GameWorld:ClearText()
		GameWorld:GameOver(false)
	
		CaptureAllGoal:Disable()
	
		self:Disable()
	end)
LossCondition:Enable()
